from enum import Enum

class VarType(Enum):
  bool = 1
  int = 2
  rat = 3
  real = 4

  def from_str(t):
    map_type = {
      "bool": VarType.bool,
      "int": VarType.int,
      "rat": VarType.rat,
      "real": VarType.real,
    }
    return map_type[t]

  def to_str(t):
    if t == VarType.bool:
      return "bool"
    if t == VarType.int:
      return "int"
    if t == VarType.rat:
      return "rat" 
    return "real"

  def from_java(t):
    map_java_type = {
      "java.lang.Boolean": VarType.bool,
      "java.lang.Integer": VarType.int,
      "java.lang.Long"   : VarType.int,
      "java.lang.Double" : VarType.rat,
      "java.lang.String" : VarType.int
    }
    return map_java_type[t]


# replacing some things in expression strings
def expr_replace(s):
  s = s.replace("And(", "(")
  rep = [ ("==", "="), (">=", "&ge;"), (">", "&gt;"), ("<=", "&le;"), 
    ("<", "&lt;"), ("+ -1*", "-")]
  for (p,r) in rep:
    s = s.replace(p,r)
  if s[0] == "(" and s[-1] == ")":
    s = s[1:-1]
  return s
